function init_widget(config){
    block();
    /// store the configuration object globally
    window.config = config;

    fontslib.loadFonts(config,function(){
        init(config);
    });

    previewlib.resize = function(){
        if(window.config.widget == 0){
            // agenda resize //
            agenda.render();
        }
        else if(window.config.widget == 1){
            // monthly resize //
            monthly.render();
            // monthly.init(window.config, monthly.events);
        }
        else if(window.config.widget == 2){
            // List resize //
            list.render();
            // list.init(window.config, list.events);
        }

        applyCss();

        if(window.config.theme == 'transparent'){
            applyTransparency();
        }
    }


}

function start_widget(){
    if(window.testing || window.inPreview) return;

    var refresh = window.config.refresh;

    // refresh *= 1000; /// convert to seconds -- Testing
    refresh *= 60000; // Convert to minutes - Deployment

    /// Clear old refresh interval if exists //
    if(window.refreshInterval) clearInterval(window.refreshInterval);

    window.refreshInterval = setInterval(function(){
        // Call the main.js update function recursively //
        update();
    }, refresh);

    if(window.config.widget == 2){
        /// Event Feed List widget ///
        // -----------------
        // -- Interval for checking time -- //
        // -----------------

        /// Clear old check time interval ///
        if(window.checkTimeInterval) clearInterval(window.checkTimeInterval);

        window.checkTimeInterval = setInterval(function(){
            /// Call refresh every 1-min ///
            console.log('Checking for update');
            list.refresh();
        }, 60000)
    }
}

function stop_widget(){
    clearInterval(window.refreshInterval);
}


function test_widget(){
    window.testing = true;

    init_widget({
        widget:2
    })
}
