/// Global object that contains the current theme style parameters ///
var theme;

/// Light-Theme CSS parameter values ////
var default_theme = {
    // Agenda time rows ///
    '--table-even-background':'#f3f3f3',
    '--table-odd-background': '#ffffff',
    '--table-border-color': '#f2efef',
    '--table-color':'#535353',

    // Agenda-Monthly Header //
    '--header-background': '#076890',
    '--header-color': '#ffffff',

    /// Monthly rows background colors ///
    '--month-week-odd-background': '#ffffff',
    '--month-week-even-background':'rgb(235, 235, 235)',
    '--month-today-background':'#80b4e3',
    '--month-textcolor':'#000000',

    /// List (Meeting-rooms)  ///
    '--list-events-active-background': '#3D9AC1', /// Current event background
    '--list-events-active-color': '#ffffff', /// Current event textcolor
    '--list-events-background':'#cec9c9', /// Rest of events background
    '--list-events-textcolor': '#000000' /// Rest of events textcolor
}

var dark_theme = {
	// Agenda time rows ///
    '--table-even-background':'#f3f3f3',
    '--table-odd-background': '#ffffff',
    '--table-border-color': '#f2efef',
    '--table-color':'#535353',

	// Agenda-Monthly Header //
    '--header-background': '#076890',
    '--header-color': '#ffffff',

	/// Monthly rows background colors ///
    '--month-week-odd-background': '#ffffff',
    '--month-week-even-background':'#fafbff',
    '--month-today-background':'#80b4e3',

	/// List (Meeting-rooms)  ///
    '--list-events-active-background': '#076890', /// Current event background
    '--list-events-active-color': '#ffffff', /// Current event textcolor
    '--list-events-background':'#3D9AC1', /// Rest of events background
    '--list-events-textcolor': '#ffffff' /// Rest of events textcolor
}


/// Applying the CSS in the corresponding HTML elements ////
function applyCss(){
    var styles = theme;

    /// In case there is no theme selected - just apply the defaults ///
    if(!styles) styles = default_theme;

    // Agenda theming //
    $('.fc-agenda-view .fc-time-grid-container table:first-child tr:nth-child(even)').css('background', styles['--table-even-background']);
    $('.fc-agenda-view .fc-time-grid-container .fc-bg .fc-day, .fc-agenda-view .fc-time-grid-container .fc-bg .fc-axis').css('background', styles['--table-odd-background']);
    $('.fc-agenda-view .fc-widget-content').css('border-color', styles['--table-border-color']);
    $('.fc-agenda-view .fc-content-skeleton td').css('border-color', styles['--table-border-color']);
    $('.fc-agenda-view .fc-time-grid-container .fc-slats tr').css('color', styles['--table-color']);

    // Monthly Theming //
    $('.fc-month-view .fc-widget-content .fc-today').css('background', styles['--month-today-background']);
    $('.fc-month-view .fc-week:nth-child(even)').css('background', styles['--month-week-even-background']);
    $('.fc-month-view .fc-week:nth-child(odd)').css('background', styles['--month-week-odd-background']);
    $(".fc-month-view .fc-day-number, .fc-month-view .fc-more").css('color', styles['--month-textcolor']);


    // List Theming //
    $('.list-event').css({
        'background' : styles['--list-events-background'],
        'color': styles['--list-events-textcolor']
    })
    $('.list-event[current-event="true"]').css({
        'background':styles['--list-events-active-background'],
        'color': styles['--list-events-active-color']
    });



    // Generic theming //
    $('.fc-view .fc-widget-header').css({
        'background': styles['--header-background'],
        'color': styles['--header-color'],
        'border-color': styles['--header-color']
    });
}

function applyTransparency(){
    $('body').css('background', 'transparent');

    $('.fc-widget-content, .fc-view .fc-widget-header').css('background', 'transparent');

    /// Monthly Transparent Theeming ///
    $('.fc-month-view .fc-widget-content .fc-today').css('background' , 'transparent');

    /// Agenda Transparent Theming ///
    $('tr').css('background', 'transparent');


    if(window.config.textcolor){
        $('.fc-view .fc-widget-header').css('color', window.config.textcolor).css('border-color', window.config.textcolor);

        /// Monthly textcolor change ///
        $(".fc-month-view .fc-day-number, .fc-month-view .fc-more").css('color', window.config.textcolor);

        /// Agenda textcolor change ///
        $('.fc-agenda-view .fc-time-grid-container .fc-axis').css('color', window.config.textcolor);
        $('.fc-agenda-view .fc-widget-content, .fc-agenda-view .fc-content-skeleton td').css('border-color', window.config.textcolor);
    }

    /// Agenda Day - Remove extra border in transparent mode ///
    $('.fc-agendaDay-view .fc-bg .fc-widget-content').css('border-color','transparent');
}

function applyThemeStyle(config){
    /// Weather to enable transparency in the widget ///
    var transparency = false;

    //// Apply the selected theme CSS ////
    switch(config.theme){
        case 'light':
            theme = default_theme;
            break;
        case 'transparent':
            theme = default_theme;
            transparency = true;

            break;
        case 'dark':
            theme = dark_theme;
			break;
		case 'custom':
            /// Custom-Theme -> Get the theme of the current widget-type ///
            if(config.widget == 0){
                theme = agenda.getCustomTheme();
            }
            else if(config.widget == 1){
                theme = monthly.getCustomTheme();
            }
            else if(config.widget == 2){
                theme = list.getCustomTheme();
            }
            else{
                theme = default_theme;
            }
			break;
        default:
            /// To customize the CSS in your own way - create an object 'custom_theme' in the 'styles.js' file
            /// And call 'applyCss(custom_theme);' here.
            break;
    }

    //// Apply the 'theme' CSS ///
    applyCss();

    if(transparency){
        applyTransparency();
    }

    /// In List Calendar always set background:transparent ///
    if(window.config.widget == 2){
        $('body').css('background', 'transparent');
    }

}

/// =============================================
// === LIVE UPDATE FUNCTIONS //
//  =============================================

/// Changing the theme of the widget will reload the page
function update_theme(theme){
    window.config.theme = theme;
    $('body').html('<div id="main"></div>');

    // init_widget(window.config);
    if(window.config.widget == 0){
        agenda.render();
    }
    else if(window.config.widget == 1){
        monthly.render();
    }
    else if(window.config.widget == 2){
        list.render();
    }

    applyThemeStyle(window.config);
}

/// Updating the font ////
function update_font(font){
    $('body').css('font-family', font);
}

// AGENDA - MONTHLY -- Change the text color -- only available in transparent theme ///
function update_textcolor(color){
    try{ color = lib.hextoRGBA(color)}
    catch(err){}

    window.config.textcolor = color;

    if(window.config.widget == 0){
        // Agenda ///
        theme = agenda.getCustomTheme();
    }
    else if(window.config.widget == 1){
        // Monthly //
        theme = monthly.getCustomTheme();
    }

    applyCss();

    if(window.config.theme == 'transparent'){
        applyTransparency();
    }
}

//// MONTHLY WIDGET Preview live update : update the bgcolor ///
function update_bgcolor(color){
    try{ color = lib.hextoRGBA(color)}
    catch(err){};

    window.config.bgcolor = color;
    theme = monthly.getCustomTheme();

    applyCss();

    // Apply the bgcolor in body //
    $('body').css('background' , color);
}


//// LIST WIDGET Preview live update : update the text color ///
function update_eventcolor(color){
    try{ color = lib.hextoRGBA(color)}
    catch(err){}

    window.config.eventcolor = color;
    theme = list.getCustomTheme();

	applyCss();
}

//// LIST WIDGET  Preview live update : update the primary color ////
function update_activebackground(color){
    try{ color = lib.hextoRGBA(color)}
    catch(err){}


    window.config.activebackground = color;
	theme = list.getCustomTheme();

	applyCss();
}

//// LIST WIDGET  Preview live update : update the secondary color ////
function update_eventbackground(color){
    try{ color = lib.hextoRGBA(color)}
    catch(err){}

    window.config.eventbackground = color;
	theme = list.getCustomTheme();

	applyCss();
}