/// This is the full monthly calendar version
/// It displays all the events of the current month

var monthly = {

    default:{/// For testing ///
        "player_params":{
            fonts:['./fonts/Montserrat.css']
        },
        "bgcolor":"#ffffff",
        "textcolor":"#000000",
        "theme":"light",
        "font":"Montserrat",
        "widget":1
    },
    calendar_config:{},
    events: [],

    init: function(config,events){
        config = this.parseColorFields(config);

        /// Apply the recurring events ///
        var last_day = this.getLastDay();
        events = this.applyRecurringEvents(events, last_day);

        /// Filter which events will be used ///
        events = this.filterEvents(events);

        this.events = events;

        this.render();
    },

    render: function(){
        reset();

        this.calendar_config = this.getConfig(config);

        /// Create the calendar in DOM ///
        $('#main').fullCalendar(this.calendar_config);

        /// Remove the toolbar ///
        $('.fc-header-toolbar').remove();

        /// Change order of time and title of every event ////
        this.optimize();

        /// If theme is custom - apply bgcolor in body ///
        if(window.config.theme == 'custom'){
            $('body').css('background', config.bgcolor);
        }
    },

    optimize: function(){
        var min_height = 140;

        var res = {height:$('body').height(), width: $('body').width()};

        var row_height = res.height / 5 - 32;
        // if(row_height < min_height) row_height = min_height;

        $('.fc-month-view .fc-week').css('height', row_height + 'px');

        if(res.width < 1280){
            /// Decrease the font-size in 1280px for better display ///
            $('.fc-month-view').css('font-size', '28px');
        }

        if(res.width < 840){
            /// Change the layout of event content in 840px ////
            $('.fc-month-view .fc-content').css('display' , 'grid');
        }
    },

    getConfig: function(config){
        return {
            plugin:'basic',
            defaultView:'month',
            timeFormat: 'H:mm', // uppercase H for 24-hour clock
            displayEventTime:true,
            displayEventEnd:true,
            eventLimit: 3,
            EventMinHeight:10,
            events: this.events
        }
    },

    // Use the 'rrule.js' library
    // To get the dates of the recurring event
    // Based on the Rules of the calendar event
    applyRecurringEvents: function(events,last_day){
        var rruleset = rrule.RRuleSet();

        var data = [];

        for(var i=0; i<events.length; i++){
            var event = events[i];
            var eventHour = moment(event.start).get('h');
            var eventMin  = moment(event.start).get('m');
            var eventEndHour = moment(event.end).get('h');
            var eventEndMin  = moment(event.end).get('m');

            // data.push(event); /// Push the original event ///

            if(event.recurrences){
                for(var re in event.recurrences){
                    var ev = event.recurrences[re];
                    ev['start'] = parseDate(ev.start);
                    ev['end']   = parseDate(ev.end);
                    ev['title'] = ev.summary;
                    ev['color'] = events[i].color;
                    ev['textColor'] = events[i].textColor;
                    ev['location'] = ev.location;
                    ev['rrule'] = ev.rrule;
                    ev['recurrences'] = ev.recurrences;
                    data.push(ev);
                }
            }

            else if(event.rrule){

                var rule = event.rrule;

                /// Add the UNTIL rule if not already exists in the RULESET ///
                if(rule.indexOf('UNTIL') < 0) rule += ';UNTIL=' + last_day.substring(0,8) + 'T060000';

                rule += ';DTSTART=' + moment(event.start).format('YYYYMMDD') + 'T060000';

                var dates = rruleset.RRule.fromString(rule).all();
                /// For every recursion of the event //
                for(var j=0; j<dates.length; j++){
                    /// Create a clone event ///
                    var temp_event = JSON.parse(JSON.stringify(event));

                    // Change it's start-date at the recursion-date //
                    temp_event.start = moment(dates[j]).set({h: eventHour, m:eventMin}).toString();
                    temp_event.end   = moment(dates[j]).set({h: eventEndHour, m:eventEndMin}).toString();

                    try{
                        /// Try to remove the GMT to place the time correctly ///
                        temp_event.start = temp_event.start.split('GMT')[0];
                    }
                    catch(err){}

                    try{
                        /// Try to remove the GMT from temp_event.end to place the time correctly ///
                        temp_event.end = temp_event.end.split('GMT')[0];
                    }
                    catch(err){};

                    data.push(temp_event);

                }
            }
            else{
                /// non-recurring event - Just push to the list ///
                data.push(event);
            }

        }

        return data;
    },

    /// Filters the events that will be used in this widget ///
    filterEvents: function(events){
        var out = [];

        for(var i=0; i<events.length; i++){
            var eventDate = events[i].start;

            if(moment(eventDate).isSame(moment(), 'day')){
                // events[i].textcolor = 'black';
                // events[i].color = 'transparent';
                out.push(events[i])
            }

            else if(moment(eventDate).isSame(moment(), 'month')){
                out.push(events[i]);
            }


        }

        /// Remove duplicated events ////
        var filtered = [];
        for(var i=0; i<out.length; i++){
            var exists = false;
            for(var j=0; j<filtered.length; j++){
                if(filtered[j].title == out[i].title && ((filtered[j].start && filtered[j].start == out[i].start) || (filtered[j].end && filtered[j].end == out[i].end))){
                    exists = true;
                }
            }

            if(!exists) filtered.push(out[i]);
        }

        return filtered;
    },

    getLastDay: function(){
        var date= moment().clone().endOf('month').format().split('-').join('').split(':').join('')
        date = date.substr(0, date.length -5);
        return date;
    },

    parseColorFields: function(config){
        try{ config.bgcolor = lib.hextoRGBA(config.bgcolor)}
        catch(err){};

        try{ config.textcolor = lib.hextoRGBA(config.textcolor)}
        catch(err){};

        window.config = config;

        return config;
    },

    //// Create a default_theme clone object for the Monthly widget
    //// Based on the values from configuration
    getCustomTheme: function(config){
        var config = window.config;

        /// Clone the default_theme object ///
        var custom = JSON.parse(JSON.stringify(default_theme));

        custom['--header-background'] = config.bgcolor;
        custom['--header-color'] = config.textcolor;
        custom['--month-week-odd-background'] = config.bgcolor;
        custom['--month-week-even-background'] = config.bgcolor;
        custom['--month-today-background'] = config.bgcolor;
        custom['--month-textcolor'] = config.textcolor;

        return custom;
    }

}