function init(config, updating){
    cdata = [];

    var load_fn = loadEvents;
    if(window.inPreview || window.testing){
        load_fn = loadTestData;
    }

    /// Load the calendar(s) ICS data ////
    load_fn(0, config.ics, function(err, events){
        if(err || !events || events.length == 0){
            if(updating){
                // If error on request - and this is an update - just ignore this update //
                console.log('Failed to update ');
                return;
            }
            /// Else if this is initialize - Just render an empty calendar //
            console.log('Something went wrong');
            events = [];
        }

        window.events = events;

        /// Initialize the corresponding widget ////
        switch(config.widget){
            case 0:
                // Agenda //
                config = $.extend(agenda.default, config);
                window.config = config;
                agenda.init(config, events);
                break;
            case 1:
                // Monthly //
                config = $.extend(monthly.default,config);
                window.config = config;
                monthly.init(config,events);
                break;
            case 2:
                // List //
                config = $.extend(list.default,config);
                window.config = config;
                list.init(config,events);

                /// List widget has always background-transparent ///
                $('body').css('background', 'transparent');
                break;
            default:
                console.error('Invalid widget configuration...');
                return;
        }

        applyThemeStyle(config);

        $('body').css('font-family', config.font);

        unblock();

        /// When refresh rate is more than 5 minutes - Convert it to semi-static widget //
        /// NOTE : Only for agenda/monthly calendars - List should never be considered as semi-static widget
        ///        Because of the dynamic content that changes the current event based on the time
        if(config.refresh > 5 && config.widget !== 2){
            setTimeout(function(){
                /// Add one-sec window in case something has not loaded yet ///
                staticlib.semiStaticLoaded(config.refersh * 60);
            }, 1000);
        }
        else{
            /// Otherwise , inform player this is not a semi-static widget ///
            staticlib.disableSemiStatic();
        }

    })
}

/// Function to update the widget on refresh interval ///
function update(){
    init(window.config, true);
}

/// Load test data for preview ////
function loadTestData(idx,urls,callb){
    data = ical.parseICS(c);

    if(!urls || urls.length == 0){
        /// If no urls - Create a dummy url object and use these colors ///
        urls = [
            { name:'Calendar Events Test', color:'transparent', textcolor:'black'}
        ]
    }

    /// Parse the color values ///
    try{urls[idx].color = lib.hextoRGBA(urls[idx].color);}
    catch(err){};

    try{urls[idx].textcolor = lib.hextoRGBA(urls[idx].textcolor);}
    catch(err){};

    /// For list-calendar - Just return the test data ///
    if(window.config.widget == 2){
        var test_data = JSON.parse(test_list_data).data
        for(var i=0; i<test_data.length; i++){
            var ev = test_data[i];
            var h_start = moment(ev.start).format('HH');
            var m_start = moment(ev.start).format('mm');

            var h_end   = moment(ev.end).format('HH');
            var m_end   = moment(ev.end).format('mm');

            test_data[i].start = moment().set({m:m_start , h:h_start});
            test_data[i].end   = moment().set({m:m_end, h:h_end});
            /// Add the 'calendar' in every test event ///
            test_data[i].calendar = urls[0].name;
        }
        callb(null, test_data);
        return;
    }

    console.log(data);
    for(var k in data){
        if(data.hasOwnProperty(k)){
            var ev = data[k];
            if(data[k].type == 'VEVENT'){
                if(ev.summary.indexOf('location') > -1) console.log(ev);
                var event = {};

                event['calendar'] = urls[idx].name.toUpperCase();
                event['start'] = parseDate(ev.start);
                event['end']   = parseDate(ev.end);
                event['title'] = ev.summary;
                event['color'] = urls[idx].color;
                event['textColor'] = urls[idx].textcolor;
                event['location'] = ev.location;
                event['rrule'] = ev.rrule;
                event['recurrences'] = ev.recurrences;
                cdata.push(event);
            }
        }
    }
    callb(null,cdata)
}

//// HTTP request to get the cal-data from given url(s) ////
// --  NOTE: Will load events from ALL given URLs , then it will callback the results ////
var cdata = [];
function loadEvents(idx,urls,callb){
    if(!urls || urls.length == 0){
        callb(null, cdata);
        return;
    }

    httplib.get({
        url:urls[idx].url,
        method:'GET'
    }, function(err,data){
        if(err) {
            /// If error on this request - procceed to the next one ///
            console.log('Error -> ' , err);
            if(++idx < urls.length) loadEvents(idx, urls, callb);
            else{
                if(cdata.length == 0){
                    callb('Failed to implement the requests - no events will be displayed');
                }
            }

            return;
        }
        else console.log('Success ');

        data = ical.parseICS(data);

        // debugger
        /// Parse the color values ///
        try{urls[idx].color = lib.hextoRGBA(urls[idx].color);}
        catch(err){};

        try{urls[idx].textcolor = lib.hextoRGBA(urls[idx].textcolor);}
        catch(err){};

        console.log(data);
        for(var k in data){
            if(data.hasOwnProperty(k)){
                var ev = data[k];
                if(data[k].type == 'VEVENT'){
                    var event = {};
                    event['calendar'] = urls[idx].name.toUpperCase();
                    event['start'] = parseDate(ev.start);
                    event['end']   = parseDate(ev.end);
                    event['title'] = ev.summary;
                    event['color'] = urls[idx].color;
                    event['textColor'] = urls[idx].textcolor;
                    event['location'] = ev.location;
                    event['rrule'] = ev.rrule;
                    event['recurrences'] = ev.recurrences;
                    cdata.push(event);
                }
            }
        }

        if(++idx < urls.length) loadEvents(idx, urls, callb)
        else callb(null, cdata);
    })
}

/// Converts the 2 -> '02:00:00' ///
function intToTime(int){
    return lib.addZero(int) + ':00:00';
}

/// Helper function - not needed yet ////
function parseDate(date){
    return date;
}

//// Reset the template ////
function reset(){
    $('body').html('<div id="main"></div>');
}

/// Show loading blocker
function block(){
    $('.overlay').show();
}

//// Hide loading blocker
function unblock(){
    $('.overlay').hide();
}
