staticlib = (function(){
    var STATIC_LOAD_COMPLETED_TEXT = '{"ready_for_cache": true}';
    var SEMI_STATIC_LOAD_COMPLETED_TEXT = '{"ready_for_cache":true , "valid_for":3600}';
    var DISABLE_SEMI_STATIC_TEXT = '{"ready_for_cache": true, "semi" : false}';
    return {
        /// Call staticlib.staticLoaded();
        /// When your widget is configured as static and everything is rendered successfully
        staticLoaded: function(){
            $('title').text(STATIC_LOAD_COMPLETED_TEXT);
        },

        /// Call staticlib.semistaticLoaded();
        /// When your widget is configured as semi-static and everything is rendered successfully
        semiStaticLoaded: function(seconds){
            if(seconds){
                SEMI_STATIC_LOAD_COMPLETED_TEXT = '{"ready_for_cache" : true, "valid_for" : ' + seconds + '}';
            }
            $('title').text(SEMI_STATIC_LOAD_COMPLETED_TEXT);
        },

        /// Call staticlib.disableSemiStatic();
        /// If widget is configured as semi-static but you want to disable it and run as a normal non-static widget
        disableSemiStatic: function(){
            $('title').text(DISABLE_SEMI_STATIC_TEXT);
        }
    }

})();


httplib = (function(){
    return {
        request: function(options,callb){
            if(!callb){
                callb = function(err,data){
                    console.log(err);
                    console.log(data);
                };
            }


            if(!options || typeof(options) !== 'object'){
                callb('bad_configuration');
                return;
            }
            if(!('url' in options)){
                callb('bad_configuration');
                return;
            }

            if(options.method !== 'GET'){
                if(!('body' in options)) options.body = '';
            }

            if(options.body && options.body !== ''){
                try{ options.body = JSON.stringify(options.body)}
                catch(err){};
            }

            if(!('success' in options) || (typeof(options.success) !== 'function')){
                options.success = function(data){
                    callb(null, data);
                }
            }

            if(!('error' in options) || (typeof(options.error) !== 'function')){
                options.error = function(xhr){
                    if(xhr.status == 200){
                        callb(null,xhr.responseText);
                        return
                    }
                    callb(xhr);
                }
            }


            options.data = options.body;

            $.ajax(options);
        },


        get: function(options, callb){
            options.method = 'GET';
            this.request(options,callb);
        },

        post: function(options,callb){
            options.method = 'POST';
            this.request(options,callb);
        },

        put: function(options, callb){
            options.method = 'PUT';
            this.request(options,callb);
        },

        delete: function(options,callb){
            options.method = 'DELETE';
            this.request(options,callb);
        }
    }
})();


proxylib = (function () {
    return {
        PROXY_URL: 'http://localhost:9999',
        request: function (options, callb) {

            if(!callb) callb = function(){};

            if(!options || typeof(options) !== 'object'){
                callb('bad_configuration', 'options');
                return;
            }

            console.log('Sending proxy request... ', options.url);

            if (!('headers' in options)) options.headers = {};

            var ajax_configuration = {
                url: this.PROXY_URL + '/request',
                method: 'POST',
                timeout: 30000,
                contentType: 'application/json',
                proxy_method:'GET',
                proxy_content_type:'application/json'
            }


            /// check for overrided proxy request timeout ////
            if ('proxy_timeout' in options) {
                ajax_configuration.timeout = options.proxy_timeout;
            }

            /// check for overrided proxy - endpoint to hit ///
            if ('proxy_endpoint' in options) {
                ajax_configuration.url = this.PROXY_URL + options.proxy_endpoint;
            }

            /// check for overrided proxy-request method ////
            if ('proxy_method' in options) {
                ajax_configuration.method = options.proxy_method;
            }

            /// check for overrided contentType ///
            if ('proxy_content_type' in options) {
                ajax_configuration.contentType = options.proxy_content_type;
            }

            /// check for overriding the headers of the request to proxy ///
            if ('proxy_headers' in options) {
                try {
                    ajax_configuration.headers = JSON.parse(options.proxy_headers);
                } catch (err) {
                    ajax_configuration.headers = options.proxy_headers;
                }
            } else {
                ajax_configuration.headers = {};
            }

            /// add the auth_token player parameter in a custom header to make sure request will be accepted by proxy ///
            if (window.config && window.config.player_params && 'auth_token' in window.config.player_params) {
                ajax_configuration.headers['Authorization'] = 'widget ' + window.config.player_params.auth_token;
            }

            // add all the data from options -- except some of the reserved keys used for proxy request settings ///
            ajax_configuration.data = {};

            var reserved_keys = ['proxy_headers', 'proxy_content_type', 'proxy_method', 'proxy_endpoint', 'proxy_timeout']; /// add the reserved keys here to exclude from JSON parameters
            for (var key in options) {
                /// check if option attribute is reserved to not include it in the JSON params ///
                var reserved = false;
                for (var i = 0; i < reserved_keys.length; i++)
                    if (key == reserved_keys[i]) reserved = true;
                if (reserved) continue;

                /// Include non-reserved option attributes as JSON parameters to the external request ////
                ajax_configuration.data[key] = options[key];
            }

            try {
                ajax_configuration.data = JSON.stringify(ajax_configuration.data)
            } catch (err) {}

            /// remove data field when request method is GET -- prevents adding URL parameters ////
            if (ajax_configuration.method == 'GET') {
                delete ajax_configuration.data;
            }

            /// callback function when request succeeded ///
            ajax_configuration.success = function (data, textStatus, response) {

                /// Checking for Response Header "X-Stale:true"
                //  --- Says this response is coming from an expired cache
                var staled = response.getResponseHeader('X-Stale') || false;
                var cache_date = response.getResponseHeader('X-Cached-Date'); /// use this to display the last updated date

                callb(null,data,staled,cache_date);
            }

            //// callback function when request failed ///
            ajax_configuration.error = function (err) {
                callb(err);
            }

            $.ajax(ajax_configuration)
        },

        /// getting the device information available ////
        getdevicedata: function (callb) {
            this.request({
                proxy_endpoint: '/device',
                proxy_method:'GET',
            },function(err,data){
                console.log('Error -> ' , err);
                console.log('Data -> ', data);
                callb(err,data);
            })
        },

    }
})()


fontslib = (function(){
    return {
        /// initialize the fonts loading ////
        loadFonts: function(config,callb){
            console.log(config);
            if(!config || !('player_params' in config) || !('fonts' in config.player_params) || config.player_params.fonts.length == 0){
                console.log('No fonts referenced in this widget');
                if(callb) callb();
                return;
            }

            var paths = config.player_params.fonts;

            fontslib.loadCssFiles(0,paths,callb);
        },

        /// Loading all css files from config.player_params.fonts field ///
        loadCssFiles: function(idx,paths,callb){
            if(!paths[idx]){
                if(callb) callb();
                return;
            }

            var path = paths[idx];

            console.log('Loading ... ', path);

            var head = document.getElementsByTagName('head')[0];
            var link = document.createElement('link');
            link.rel = 'stylesheet';
            link.type = 'text/css';
            link.href = path;
            link.media = 'all';
            link.addEventListener('load', function(){
                if(++idx < paths.length) fontslib.loadCssFiles(idx, paths, callb);
                else{
                    if(callb) callb();
                }
            });
            link.addEventListener('error', function(){
                if(++idx < paths.length) fontslib.loadCssFiles(idx, paths, callb);
                else{
                    if(callb) callb();
                }
            })
            head.appendChild(link);
        },

        /// Function to load a specific Font Css file ////
        loadCustomCSSFile: function(url,callb){
            if(!url){
                console.log('Specify the URL of the CSS file to load');
                if(callb) callb();
                return;
            }

            var head = document.getElementsByTagName('head')[0];
            var link = document.createElement('link');
            link.rel = 'stylesheet';
            link.type = 'text/css';
            link.href = url;
            link.media = 'all';

            link.addEventListener('load', function(){
                if(callb) callb();
            });

            link.addEventListener('error', function(){
                console.log('Failed to load file :::: ' , url );
                if(callb) callb('Failed');
            });

            head.appendChild(link);
        }
    }
})()


previewlib = (function(){
    return {

        preview_widget: function(custom_config){
            /// getting configuration ///
            var config = custom_config || previewlib.getURLParameters();

            config = $.extend({
                //// add the default configuration values for your preview here

            }, config);

            /// store config object globally ///
            window.config = config;

            /// make sure to apply the given zoom from the UI page ///
            if('zoom' in config){
                var resolution = 100 / config.zoom;
                $('html').attr('style', 'width : ' + resolution + '% !important; height : ' + resolution + '% !important;');
                $('html').css('transform' ,'scale(' +  config.zoom + ')').css('transform-origin', 'top left');
            }

            //// Handle resize event
            var resizeTimer;
            $(window).on('resize' , function(){
                if(resizeTimer) clearTimeout(resizeTimer);

                resizeTimer = setTimeout(function(){
                    previewlib.resize();
                }, 250)
            });


            /// Initialize and Start the widget ///
            init_widget(config);

            start_widget();
        },

        /****************************************************************
         * Handle what happens when a resize in the widget is happening
         *  -- NOTE: This resize is triggered when the end-user
         *           Is resizing the region this widget is attatched in the layout
        */
       resize: function(){
            stop_widget();

            init_widget(window.config);

            start_widget();
       },

        /**
         * Getting the configuration object from the URL parameters *
         * And zoom percentage to apply in the body of HTML *
         */
        getURLParameters: function(){
            var params = {};
            var uri = window.location.href;
            uri = uri.replace(/\+/g, "%20"); /// the encoded url from Back-end has replaced the ' ' character with '+'

            uri.replace(/[?&]+([^=&]+)=([^&]*)/gi , function(m, key, value){
                try{
                    value = decodeURIComponent(value);
                    value = JSON.parse(value);
                }
                catch(err){}

                params[key] = value;
            })
            console.log(params);
            return params;
        },


        /************************************************************
         *** Callback function for postMessage event handler *****
        */
        receiveMessage: function(event){
            var data = event.data;

            //// need to have stored the configuration object globally in the 'config' argument ///
            if(!window.config) return;

            if('fields' in data){
                stop_widget();
                var need_update = false;
                for(var field in data.fields){
                    window.config[field] = data.fields[field];
                    var fnname = 'update_' + field;
                    if(fnname in window){
                        window[fnname](data.fields[field]);
                    }
                    else if(fnname in previewlib){
                        previewlib[fnname](data.fields[field]);
                    }
                    else need_update = true;
                }

                if(need_update){
                    init_widget(window.config);
                }
                start_widget();
            }

            if('functions' in data && Array.isArray(data.functions) && data.functions.length > 0){
                for(var i=0; i<data.functions.length; i++){
                    var func = data.functions[i];
                    if(!('fname' in func)){ console.log('Specify "fname" tu run the function'); continue;}
                    if(func.fname in window){
                        if('data' in func) window[func.fname](func.data);
                        else window[func.fname]();
                    }
                    else if(func.fname in this){
                        if('data' in func) this[func.fname](func.data);
                        else this[func.fname]();
                    }
                    else{
                        try{
                            if('data' in func){
                                var eval_str = func.fname + '(';
                                if(typeof(func.data) == 'string'){
                                    eval_str += '"' + func.data + '")';
                                }
                                else{
                                    eval_str += func.data + ')';
                                }
                                eval(eval_str);
                            }
                            else{
                                eval(func.fname + '()');
                            }
                        }
                        catch(err){
                            console.log(err);
                            console.log('Function ' + func.fname + ' was not found globally in the widget');
                        }
                    }
                }
            }
        }

    }
})();

dev = (function(){
    return {
        DEVICE_OWNER: 'Devel Widget',
        domain:'http://localhost:8080',

        enable_debug: function(settings){
            /// checks for WebSocket Script
            if(!io){
                console.error('Socket IO script is missing ');
                return;
            }

            /// Checks for Settings paremeter ///
            if(!settings){
                console.error('No configuration for enabling debugging');
                return;
            }

            if(!settings.domain){
                console.error('Specify IP address of debugging server');
                return;
            }

            dev.domain = settings.domain;

            port = settings.port || 80;


            var domain = settings.domain;

            if(settings.logs){
                window.old_log = console.log;
                console.log = function(msg,msg2){
                    if(msg2) msg += ' ' + msg2;
                    $.ajax({
                        url:domain + ':' + port + '/log',
                        data:{owner: dev.DEVICE_OWNER, msg:msg}
                    })
                }
                window.onerror = function(error,url,line,file,errObj){
                    console.log(errObj);
                    $.ajax({
                        url:domain + ':' + port + '/error',
                        data:{ owner: dev.DEVICE_OWNER, msg:error,url:url,line:line,file:file,fileNumber:errObj}
                    })
                }

            }
            console.log('Debug enabled!');
            var socket = io(domain + ':8002');

            socket.on('poll', function(){
                socket.emit('respond_poll', {name:dev.DEVICE_OWNER})
            })
            socket.on('command_call', function(obj){
                var str = obj.str;
                var log = obj.log || 'No log'
                if('owner' in obj){
                    if(obj.owner !== dev.DEVICE_OWNER) {
                        return;
                        ////// if socket command for a specific user different than the current one /////
                    }
                }

                var response = eval(str);
                $.ajax({
                    url:domain + ':' + port +  '/log',
                    data:{owner:dev.DEVICE_OWNER, msg:response}
                })
                console.log(log);
            })

            socket.on('request_html_call', function(obj){
                var selector = obj.el || 'body';
                var html = $(selector).html()

                socket.emit('respond_html', {html:html});
            })

            socket.on('respond_html_call', function(){

            })

            //logerrors('init_widget');
            //logerrors('start_widget');
            //logerrors('stop_widget');

            console.log("Connected")
        },

        logerrors: function(name){
            console.log('Logging ' + name + ' function');
            if(!(name in window)) { console.log(name + ' is not a global function.'); return;}
            var old_fn = window[name]

            window[name] = function(){
                var args = arguments;
                console.log(args);
                $(dev.wrapErrors(function(){
                    if(arguments.length > 0){
                        old_fn.apply(null,arguments);
                    }
                    old_fn.apply();
                }))

            }
        },

        captureError: function(ex){
            var errorData = {
                name: ex.name, // e.g. ReferenceError
                message: ex.message, // e.g. x is undefined
                url: document.location.href,
                stack: ex.stack, // stacktrace string; remember, different per-browser!
                line:ex.lineNumber,
                file:ex.fileName
            }
            $.ajax({
                url:dev.domain + '/error',
                data:errorData,

            })
        },

        wrapErrors: function(fn){
            if(!fn.__wrapped__){
                fn.__wrapped__ = function(){
                    try{
                        return fn.apply(this,arguments);
                    }
                    catch(e){
                        captureError(e);
                        throw e;
                    }
                }
            }
            return fn.__wrapped__;
        }
    }
})();

lib = (function(){
    return {
        getMilisecondsFromDate: function(date){
            date = new Date(date);

            return date.getTime();
        },

        addZero: function(val){
            if(val < 10) return '0' + val;
            return val;
        },

        objectIsEmpty: function(obj){
            for(var key in obj) {
                if(obj.hasOwnProperty(key))
                    return false;
            }
            return true;
        },

        strip: function(html){
            var doc = new DOMParser().parseFromString(html, 'text/html');
            return doc.body.textContent || "";
        },

        /// strip the html characters ///
        stripHTML: function(my_string){
            var charArr   = my_string.split(''),
                resultArr = [],
                htmlZone  = 0,
                quoteZone = 0;
            for( x=0; x < charArr.length; x++ ){
             switch( charArr[x] + htmlZone + quoteZone ){
               case "<00" : htmlZone  = 1;break;
               case ">10" : htmlZone  = 0;resultArr.push(' ');break;
               case '"10' : quoteZone = 1;break;
               case "'10" : quoteZone = 2;break;
               case '"11' :
               case "'12" : quoteZone = 0;break;
               default    : if(!htmlZone){ resultArr.push(charArr[x]); }
             }
            }
            return resultArr.join('');
        },

        /**
         *  Deep search inside a javascript object to find the FIRST (object[key])
         * @param {*Object to iterate} object
         * @param {*Key variable to find in @object} key
         * @param {*Callback function returning the value of the @object[@key]} predicate
         */
        deepSearch: function(object, key, predicate) {
            if (object.hasOwnProperty(key) && predicate(key, object[key]) === true) return object

            for (var i = 0; i < Object.keys(object).length; i++) {
              if (typeof object[Object.keys(object)[i]] === "object") {
                var o = deepSearch(object[Object.keys(object)[i]], key, predicate)
                if (o != null) return o
              }
            }
            return null
        },

        hextoRGB: function(hex){
            // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
            var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
            hex = hex.replace(shorthandRegex, function(m, r, g, b) {
                return r + r + g + g + b + b;
            });

            var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
            return result ? {
                r : parseInt(result[1], 16),
                g : parseInt(result[2], 16),
                b : parseInt(result[3], 16)
            } : null;
        },


        hextoRGBA: function(hex){
            var r = parseInt(hex.substr(0,2),16);
            var g = parseInt(hex.substr(2,2),16);
            var b = parseInt(hex.substr(4,2),16);
            var a = Math.round(parseInt(hex.substr(6,2),16) / 2.55)/100;

            if(isNaN(r+g+b+a)) return hex;

            var rgba='rgba('+r+','+g+','+b+','+a+')'

            return rgba;
        }
    }
})();


(function(){
    //// Handler for an iframe postMessage event ///
    window.addEventListener('message', previewlib.receiveMessage, false);

    // dev.enable_debug({
    //     domain:'http://<<local_pc_ip>>',
    //     port: 8080,
    //     logs:true
    // })

})();