/**
 * RSS FEED GENERATOR WIDGET
 * ================================
 *  -- Give an RSS url and display feed with custom style configuration given at portal
 */

 /**
  * ------------------------ Configuration options --------------------------------- *
  * -- 'widget' attribute :
  * --------- > DESCRIPTION : From widget configuration - Every News RSS widget sends an attribute named 'widget' . This defines what kind of news RSS widget this is.
  * ----------------------- > Then this widget will call the function of the selected widget as shown below this comment.
  * ----------------------- > For example, if widget is CNN it will send from the configuration 'widget:2',
  * ----------------------- > then widget will load functions from 'cnn.js' file which includes the getURL and 'test' functions to return the URL for request
  * --------- > NOTE: If (for some reason) there is no 'widget' attribute in configuration , by default it will be set to 0 and load the CUSTOM RSS FEED
  * ---- 0 : Custom RSS
  * ---- 1 : BBC RSS
  * ---- 2 : CNN RSS
  * ---- 3 : Google News RSS
  * ---- 4 : ESPN RSS
  * ---- 5 : Al Jazeera RSS
  */
function init_widget(config){
    window.tasksDone = false; // flag for start widget
    window.articleLinks = []; // array to store the links for 'refresh' checks

    if('defaultImage' in config) window.defaultImage = config.defaultImage;

    console.log(config);
    /// default values if not given ///
    config = $.extend({
        number_of_slides:5,
        refresh_rate:30,
        font_color:'black',
        rgba_color:'white',
        font_size:27,
        slide_duration:5,
        feedImage:window.feedImage,
        testing:false, /// set true to enable testing phase of the widget in browser
        widget:0
    }, config);

    // try{ config.widget = parseInt(config.widget);}
    // catch(err){}

    window.options = config;


    /////// Configure which widget will be used //////////
    var feed_url;
    switch(config.widget){
        case 0: case "0":  feed_url = get_CUSTOM_url(); test = test_custom_widget; break;
        case 1: case "1":  feed_url = get_BBC_url(); test = test_bbc_widget; break;
        case 2: case "2":  feed_url = get_CNN_url(); test = test_cnn_widget; break;
        case 3: case "3":  feed_url = get_GOOGLE_NEWS_url(); test = test_google_news_widget; break;
        case 4: case "4":  feed_url = get_ESPN_url(); test = test_espn_widget; break;
        case 5: case "5":  feed_url = get_AL_JAZEERA_url(); test = test_al_jazeera_widget; break;
        default: feed_url = get_CUSTOM_url(); test = test_custom_widget; break;
    }

    ///// if test_widget is called --- testing widget in browser ////
    if('testing' in config && config.testing){
        delete config['testing'];
        test();
        return;
    }

    console.log('Feed URL : ' , feed_url);
    // var feed_url = getURL();
    window.feed_url = feed_url; // allowed to change url via debugger

    if(!feed_url){
        return; // invalid config file , missing "news" field.
    }


    // var url = 'http://10.20.111.118/test'; /// pass through proxy to get xml data
    // var url = feed_url;

    console.log('Sending .... ');

    /// requestXMLdata -> lib.js file ////
    requestXMLdata(function(err,data){
        $('.main').html(''); /// clear html div to render new data

        if(!validateXML(data)){
            console.log('Error on validate XML response');
            error('url_no_xml');
            return;
        }

        var json = parser.parse(data,{ignoreAttributes:false});
        console.log(json);

        /// get thumbnail ////
        // deepSearch(json, 'channel', function(key, channel){
            // if(channel) if('image' in channel) if('url' in channel.image) window.logo = channel.image.url;
        // })

        deepSearch(json , 'image', function(key,image) {
            if(image){
                if(typeof(image) == 'object' && 'url' in image) image = image.url;
                json['feedImage'] = image;
                window.options.feedImage = image;
            }
        })
        console.log(json);
        /// use deepSearch function to iterate generated json and find the 'items'
        var out = [];
        deepSearch(json,'item', function(key,items){
            ///// render posts in DOM
            ///// with display:none property

            render(items);
            return
            /**
             * Update attributes of ALL XML items *
             * (Recursive function cause of 'getImage' function (request to proxy) async)
             */
            var updateAttributes = function(idx, items, callback){
                var item = items[idx];
                if(!item || idx >= window.options.number_of_slides){ callback(); return ;}

                if(window.options.feedImage) item.feedImage = window.options.feedImage;

                if(!('description' in item)) item.description = '';
                else{
                    //// remove html tags from description if exists ////
                    item.description = strip(item.description);
                    item.description = stripHTML(item.description);
                }

                if(!('title' in item)) item.title = '';

                if(!('pubDate' in item)) item.pubDate = '';

                if('link' in item){
                    window.articleLinks.push(item.link); /// update the local article links array for 'refresh' checks

                    getImage(item.link, function(err,image){
                        if(!image){
                            item.image = window.defaultImage; // set an icon related to content if not found in rss article
                        }
                        else{
                            console.log('Image ' + idx + ' : ' + image);
                            item.image = image;
                        }
                        out.push(item);
                        updateAttributes(idx+1, items, callback);
                    })
                }
                else{
                    item.image = window.options.feedImage || window.defaultImage; /// set an icon related to content if no link is found to search for image
                    out.push(item);
                    updateAttributes(idx + 1, items , callback);
                }
            }
            /// update attributes of all XML items recursively ///
            updateAttributes(0, items, function(){
                console.log('All items are updated');
                render(out);
            })
        })
    })
}


function resize_image(width, feed, container, callb){
    $(container + ' .image-container').css('width' , width + '%');
    $(container + ' .feed-container').css('width', (100-width) + '%');

    width -= 1;

    if($(container).height() >= $(window).height() && width > 15){
        resize_image(width, feed, container, callb)
    }
    else{
        callb();
    }
}

function render(items){
    console.log('Items -> ' ,items);
    var i = 0;

    var _recursion = function(idx,callb){
        var item = items[idx];
        if(!item || idx >= window.options.number_of_slides){ callb(); return; }

        if(window.options.feedImage) item.feedImage = window.options.feedImage;

        if(!('description' in item)) item.description = '';
        else{
            // remove html tags from description if exists ///
            item.description = strip(item.description);
            item.description = stripHTML(item.description);
        }


        if(!('title' in item)) item.title = '';
        if(!('pubDate' in item)) item.pubDate = '';

        if('link' in item){
            window.articleLinks.push(item.link); /// update the local article links array for 'refresh' checks

            getImage(item.link, function(err,image){
                if(!image){
                    item.image = window.defaultImage; // set an icon related to content if not found in rss article
                }
                else{
                    console.log('Image ' + idx + ' : ' + image);
                    item.image = image;
                }
                // out.push(item);
                render_feed(idx,item,function(){
                    _recursion(idx+1, callb);
                });

            })
        }
        else{
            item.image = window.options.feedImage || window.defaultImage; /// set an icon related to content if no link is found to search for image
            // out.push(item);
            render_feed(idx,item, function(){
                _recursion(idx + 1,  callb);
            })
        }
    }

    var render_first = function(callb){
        var idx = 0;
        var item = items[idx];
        if(!item || idx >= window.options.number_of_slides){ callb(); return; }

        if(window.options.feedImage) item.feedImage = window.options.feedImage;

        if(!('description' in item)) item.description = '';
        else{
            // remove html tags from description if exists ///
            item.description = strip(item.description);
            item.description = stripHTML(item.description);
        }


        if(!('title' in item)) item.title = '';
        if(!('pubDate' in item)) item.pubDate = '';

        if('link' in item){
            window.articleLinks.push(item.link); /// update the local article links array for 'refresh' checks

            getImage(item.link, function(err,image){
                if(!image){
                    item.image = window.defaultImage; // set an icon related to content if not found in rss article
                }
                else{
                    console.log('Image ' + idx + ' : ' + image);
                    item.image = image;
                }
                // out.push(item);
                render_feed(idx,item,function(){
                    callb();
                });

            })
        }
        else{
            item.image = window.options.feedImage || window.defaultImage; /// set an icon related to content if no link is found to search for image
            // out.push(item);
            render_feed(idx,item, function(){
                callb();
            })
        }
    }

    var render_feed = function(idx,feed, callb){
        console.log(feed);
        if(!feed || idx > (window.options.number_of_slides - 1)){ callb(); return;} // recursion ends

        if($(window).width() >= $(window).height() + 100) {
            var html = horizontal(feed, idx);
            var isvertical = false;
        }
        else {
            var html = vertical(feed, idx);
            var isvertical = true;
        }

        console.log('Append html of feed : ' , idx );
        $('.main').append(html);
        $('#feed-' + idx).addClass('feed-mask')
        applyConfigurationStyles('#feed-' + idx);

        // $('#feed-' + idx + ' .image-container').css('height' , ($(window).height() + 'px'))

        $('#feed-' + idx + ' .image-container img').load(function(){
            if(isvertical){
                $('#feed-'  + idx + ' .image-container').css('width', '100%')
            }
            else{
                resize_image(65, feed, '#feed-' + idx, function(){
                })
            }

            $('#feed-' + idx).hide();
            $('#feed-' + idx).removeClass('feed-mask');
            clearTimeout(timeout); //// clear load fail image handle timeout
            window.last_rendered_index = idx;

            callb();
            // recursion(idx + 1, callb); //// go to next feed

        })

        var timeout =  setTimeout(function(){
            $('#feed-' + idx).hide();
            window.last_rendered_index = idx;
            //// timeout to handle failure of load image in 5 seconds ////
            ///// gets cleared if image is loaded ///////
            callb();
            // recursion(idx + 1, callb);
        }, 50000);
    }


    render_first(function(){
        //// render & show the first one
        $('.mask').addClass('hidden');
        $('#feed-0').show();
        window.last_rendered_index = 0;
        window.tasksDone = true;
        _recursion(1,function(){
            $('.feed').removeClass('feed-mask');

            window.tasksDone = true;
            window.all_slides_are_rendered = true;
        })
    })

    return;

    var recursion = function(idx, callb){
        var feed = feeds[idx];

        console.log(feed);
        if(!feed || idx > (window.options.number_of_slides - 1)){ callb(); return;} // recursion ends

        if($(window).width() >= $(window).height() + 100) {
            var html = horizontal(feed, idx);
            var isvertical = false;
        }
        else {
            var html = vertical(feed, idx);
            var isvertical = true;
        }

        console.log('Append html of feed : ' , idx );
        $('.main').append(html);
        $('#feed-' + idx).addClass('feed-mask')
        applyConfigurationStyles('#feed-' + idx);

        // $('#feed-' + idx + ' .image-container').css('height' , ($(window).height() + 'px'))

        $('#feed-' + idx + ' .image-container img').load(function(){
            if(isvertical){
                $('#feed-'  + idx + ' .image-container').css('width', '100%')
            }
            else{
                resize_image(65, feed, '#feed-' + idx, function(){
                })
            }

            $('#feed-' + idx).hide();
            $('#feed-' + idx).removeClass('feed-mask');
            clearTimeout(timeout); //// clear load fail image handle timeout
            window.last_rendered_index = idx;

            recursion(idx + 1, callb); //// go to next feed

        })

        var timeout =  setTimeout(function(){
            $('#feed-' + idx).hide();
            window.last_rendered_index = idx;
            //// timeout to handle failure of load image in 5 seconds ////
            ///// gets cleared if image is loaded ///////
            recursion(idx + 1, callb);
        }, 50000);

    }

    render_first(function(){
        $('.mask,.refresh-mask').addClass('hidden');
        $('#feed-0').show();
        window.last_rendered_index = 0;
        window.tasksDone = true;

        recursion(1, function(){
            // $('#feed-0').show();
            // $('.mask,.refresh-mask').addClass('hidden');
            $('.feed').removeClass('feed-mask');

            window.tasksDone = true;
            window.all_slides_are_rendered = true;
        });
    })







}


/**
 *  Deep search inside a javascript object to find the FIRST (object[key])
 * @param {*Object to iterate} object
 * @param {*Key variable to find in @object} key
 * @param {*Callback function returning the value of the @object[@key]} predicate
 */
function  deepSearch (object, key, predicate) {
    if (object.hasOwnProperty(key) && predicate(key, object[key]) === true) return object

    for (var i = 0; i < Object.keys(object).length; i++) {
      if (typeof object[Object.keys(object)[i]] === "object") {
        var o = deepSearch(object[Object.keys(object)[i]], key, predicate)
        if (o != null) return o
      }
    }
    return null
}


var current_slide = 0;
function start_slide_interval(){
    /// first slide is visible ///
    window.interv = setInterval(function(){
        //// if slide is not ready yet
        if(!window.last_rendered_index || window.last_rendered_index < (current_slide + 1)) {
            if(!window.all_slides_are_rendered){
                return;
            }
        }

        $('#feed-' + current_slide).hide();
        current_slide ++;
        if($('#feed-' + current_slide).length > 0){
            $('#feed-' + current_slide).show();
        }
        else{
            current_slide = 0;
            $('#feed-0').show();
        }
        console.log('Changing to slide : ' , current_slide);
    }, window.options.slide_duration * 1000)
}

function stop_slide_interval(){
    clearInterval(window.interv);
}

function start_refresh_interval(){
    var REFRESH_WIDGET_INTERVAL_TIME = window.options.refresh_rate;
    if(typeof(REFRESH_WIDGET_INTERVAL_TIME) !== 'number' || REFRESH_WIDGET_INTERVAL_TIME < 1) {
        REFRESH_WIDGET_INTERVAL_TIME = 30; // default refresh rate time for failure bugs
    }

    REFRESH_WIDGET_INTERVAL_TIME *= 60; //// refresh in minutes ////

    // also make it *60 (for minutes) on release //

    //var REFRESH_WIDGET_INTERVAL_TIME = 15; ///// deafult 15 seconds -- change to apply from configuration
    window.refresh_interval = setInterval(function(){
        /** WHEN TIME TO REFRESH THE WIDGET **
         * 1. stop refresh interval
         * 2. request XML data
         * 3. check if there are NEW posts to show
         * 4. if not, start refresh interval again
         * 5. if yes,
         *  5a) show "refresh mask"
         *  5b) window.tasksDone = false --- to disable start widget from changing slides
         *  5c) call init_widget function again
         *  5d) set current slide to 0
         *  5e) start widget --
         */

        // 1 -- stop refresh interval
        stop_refresh_interval();

        // 2 -- request XML data
        requestXMLdata(function(err,data){
            console.log(1);
            if(!err && data){
                /// if no errors
                if(!validateXML(data)){
                    console.log('Error on validate XML (REFRESH WIDGET)');
                }
                else{
                    console.log(2);
                    var json = parser.parse(data,{ignoreAttributes:false});
                    var links = [];
                    deepSearch(json, 'item', function(key,items){
                        for(var i=0; i<items.length; i++){
                            var item = items[i];
                            if('link' in item) links.push(item.link);
                        }

                        console.log(3);
                        // 3
                        if(!xmlUpdated(links)){
                            // 4 -- no XML updates
                            console.log('No XML updates');
                            window.hasFreshData = false;
                        }
                        else{
                            window.hasFreshData = true;

                            stop_slide_interval(); // stop slide change interval

                            $('.mask').removeClass('hidden'); // 5a -- show refresh mask
                            // var w = $('.refresh-widget-message').width()
                            // $('.refresh-widget-message').css('margin-left','-' + (w/2) + 'px').css('max-width', (w + 100) + 'px'); // css for refresh mask

                            window.tasksDone = false; // 5b -- disable intervals to work
                            init_widget(window.options); // 5c -- re-render widget
                            current_slide = 0; // 5d -- start from zero slide
                            start_widget(); // 5e -- start widget (start both intervals when init widget is finished loading)
                        }
                    })
                }
            }

            // 4 -- start refresh interval
            if(!window.hasFreshData) start_refresh_interval();
        }, true) // set true to inform it's a refresh



    }, REFRESH_WIDGET_INTERVAL_TIME * 1000)
}

function stop_refresh_interval(){
    clearInterval(window.refresh_interval);
}

function start_widget(){
    if(!window.tasksDone){
        setTimeout(function(){
            start_widget();
        }, 500);

        return;
    }

    start_slide_interval();
    start_refresh_interval();

}

function stop_widget(){
    stop_refresh_interval();
    stop_slide_interval();
}

/// call test_widget in browser console with one parameter type of 'string' or 'integer'
/// to define what widget to test (custom rss / bbc / cnn / google news / espn / al jazeera)
function test_widget(widget){
    if(!widget) widget = 0;
    /// Test function with a custom configuration object ///
    var config = {
        widget:widget,
        testing:true
    }

    init_widget(config)
}

function show_widget(){}
function hide_widget(){}