function test_google_news_widget(){
    /// Test function with a custom configuration object ///
    var config = {
        slide_duration:5,
        number_of_slides:15,
        font_color:'black',
        rgba_color:'white',
        font_size:27,
        news:0,
        country:"hl=el&gl=GR&ceid=GR:el",
        defaultImage:window.defaultImage,
        feedImage:window.feedImage,
        widget:3
    }

    init_widget(config)
}

function get_GOOGLE_NEWS_url(){
    window.defaultImage = 'assets/google-news-def.png';
    // window.feedImage = 'assets/google-news.png';
    window.feedImage = '';

    var config = window.options;

    if(!('news' in config)){
        console.log('Invalid configuration file -- Missing "news" field.');
        return;
    }

    if(!('country' in config)){
        console.log('Invalid configuration file -- Missing "country" field.');
        return;
    }

    try{
        config.news = parseInt(config.news);
    }
    catch(err){

    }

    var url = '';

    switch(config.news){
        case 0:
            url += 'https://news.google.com/rss'; /// Top Stories
            break;
        case 2:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNRGx1YlY4U0FtVnVHZ0pWVXlnQVAB'; //// World
            break;
        case 3:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNRGx6TVdZU0FtVnVHZ0pWVXlnQVAB'; //// Business
            break;
        case 4:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNRGRqTVhZU0FtVnVHZ0pWVXlnQVAB'; ///// Technology
            break;
        case 5:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNREpxYW5RU0FtVnVHZ0pWVXlnQVAB'; //// Entertainment
            break;
        case 6:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNRFp1ZEdvU0FtVnVHZ0pWVXlnQVAB'; //// Sports
            break;
        case 7:
            url += 'https://news.google.com/rss/topics/CAAqJggKIiBDQkFTRWdvSUwyMHZNRFp0Y1RjU0FtVnVHZ0pWVXlnQVAB'; //// Science
            break;
        case 8:
            url += 'https://news.google.com/rss/topics/CAAqIQgKIhtDQkFTRGdvSUwyMHZNR3QwTlRFU0FtVnVLQUFQAQ'; //// Health
            break;
        default:
            url += 'https://news.google.com/rss';
            break;
    }

    url += '?' + config.country;
    return url
}