function test_espn_widget(){
    /// Test function with a custom configuration object ///
    var config = {
        slide_duration:2,
        number_of_slides:5,
        font_color:'black',
        rgba_color:'white',
        font_size:27,
        news:0,
        defaultImage:window.defaultImage,
        feedImage:window.feedImage,
        widget:4
    }

    init_widget(config)
}

/**
 * Convert the 'news' attribute from configuration to the proper URL
 */
function get_ESPN_url(){
    window.feedImage = 'assets/espn.png';
    window.defaultImage = 'assets/espn-def.png';

    var config = window.options;

    if(!('news' in config)){
        console.log('Invalid configuration file <br> Missing "news" field. ');
        return;
    }

    try{
        config.news = parseInt(config.news);
    }
    catch(err){

    }

    switch(config.news){
        case 0:
            return "http://www.espn.com/espn/rss/news"; // Top Headlines -- CHECKED
        case 1:
            return "http://www.espn.com/espn/rss/nfl/news"; // NFL Headlines -- CHECKED
        case 2:
            return "http://www.espn.com/espn/rss/nba/news"; // NBA Headlines -- CHECKED
        case 3:
            return "http://www.espn.com/espn/rss/mlb/news"; // MLB Headlines -- CHECKED
        case 4:
            return "http://www.espn.com/espn/rss/nhl/news"; // NHL Headlines -- CHECKED
        case 5:
            return "http://www.espn.com/espn/rss/rpm/news"; // Motorsports Headlines -- CHECKED
        case 6:
            return "http://soccernet.espn.com/rss/news"; // Soccer Headlines -- ********* NOT WORKING ********** ----- REMOVED
        case 7:
            return "http://www.espn.com/espn/rss/espnu/news"; // ESPNU -- CHECKED
        case 8:
            return "http://www.espn.com/espn/rss/ncb/news"; // College Basketball Headlines --- CHECKED
        case 9:
            return "http://www.espn.com/espn/rss/ncf/news"; // College Football Headlines ---- CHECKED
        case 10:
            return "http://www.espn.com/espn/rss/action/news"; // Action Sports Headlines --- ****** NOT WORKING ******* ----- REMOVED
        case 11:
            return "http://www.espn.com/espn/rss/poker/master"; // Poker news Headlines --- REMOVED
        case 12:
            return "http://search.espn.com/rss/bill-simmons/"; // Bill Simmons Columns --- ****** NOT WORKING ******* ---- REMOVED
        case 13:
            return "http://www.grantland.com/feed"; // Grantland --- CHECKED
        case 14:
            return "http://www.espn.com/espn/rss/recruiting/osu/news"; // Buckeye nation ESPN --- CHECKED
        case 15:
            return "http://www.espn.com/espn/rss/recruiting/georgia/news"; // Dawg Nation ESPN --- CHECKED
        case 16:
            return "http://www.espn.com/espn/rss/recruiting/oregon/news"; // Duck Nation ESPN --- CHECKED
        case 17:
            return "http://www.espn.com/espn/rss/recruiting/florida/news"; // Gator Nation ESPN --- CHECKED
        case 18:
            return "http://www.espn.com/espn/rss/recruiting/tamu/news"; // GigEm Nation ESPN --- CHECKED
        case 19:
            return "http://www.espn.com/espn/rss/recruiting/lsu/news"; // Gueaux Tiger Nation ESPN --- CHECKED
        case 20:
            return "http://www.espn.com/espn/rss/recruiting/texas/news"; // Horns Nation ESPN -- CHECKED
        case 21:
            return "http://www.espn.com/espn/rss/recruiting/washington/news"; // Husky Nation ESPN -- CHECKED
        case 22:
            return "http://www.espn.com/espn/rss/recruiting/psu/news"; // Nittany Nation ESPN --- CHECKED
        case 23:
            return "http://www.espn.com/espn/rss/recruiting/fsu/news"; // Nole Nation ESPN --- CHECKED
        case 24:
            return "http://www.espn.com/espn/rss/recruiting/oklahoma/news"; // Sooner Nation ESPN -- CHECKED
        case 25:
            return "http://www.espn.com/espn/rss/recruiting/alabama/news"; // Tide Nation ESPN -- CHECKED
        case 26:
            return "http://www.espn.com/espn/rss/recruiting/usc/news"; // We Are SC -- CHECKED
        case 27:
            return "http://www.espn.com/espn/rss/recruiting/michigan/news"; // Wolverine Nation ESPN -- CHECKED
    }
}