// default domain http://10.20.111.130
var DEVICE_OWNER = 'rss widget';
function activate_debugging(config){
    if(!config){
        console.log('No configuration for activate debugging');
        return;
    }
    port = config.port || 80;


    var domain = config.domain || 'http://10.20.111.38';

    if(config.logs){
        window.old_log = console.log;
        console.log = function(msg,msg2){
            if(msg2) msg += ' ' + msg2;
            $.ajax({
                url:domain + ':' + port + '/log',
                data:{owner: DEVICE_OWNER, msg:msg}
            })
        }
        window.onerror = function(error,url,line,file,errObj){
            console.log(errObj);
            $.ajax({
                url:domain + ':' + port + '/error',
                data:{ owner: DEVICE_OWNER, msg:error,url:url,line:line,file:file,fileNumber:errObj}
            })
        }

    }
    console.log('Debug enabled!');
    var socket = io(domain + ':8002');

    socket.on('poll', function(){
        socket.emit('respond_poll', {name:DEVICE_OWNER})
    })
    socket.on('command_call', function(obj){
        var str = obj.str;
        var log = obj.log || 'No log'
        if('owner' in obj){
            if(obj.owner !== DEVICE_OWNER) {
                return;
                ////// if socket command for a specific user different than the current one /////
            }
        }

        var response = eval(str);
        $.ajax({
            url:domain + ':' + port +  '/log',
            data:{owner:DEVICE_OWNER, msg:response}
        })
        console.log(log);
    })

    socket.on('request_html_call', function(obj){
        var selector = obj.el || 'body';
        var html = $(selector).html()

        socket.emit('respond_html', {html:html});
    })

    socket.on('respond_html_call', function(){

    })

    //logerrors('init_widget');
    //logerrors('start_widget');
    //logerrors('stop_widget');
}

///// enable error logs for selected GLOBAL function ///////
function logerrors(name){
    console.log('Logging ' + name + ' function');
    if(!(name in window)) { console.log(name + ' is not a global function.'); return;}
    var old_fn = window[name]

    window[name] = function(){
        var args = arguments;
        console.log(args);
        $(wrapErrors(function(){
            if(arguments.length > 0){
                old_fn.apply(null,arguments);
            }
            old_fn.apply();
        }))

    }

}

function activate_error_handling(){
    console.log('Activate error handling for all global functions');
    for(var key in window){
        console.log(key);
        if(typeof(window[key] == 'function')){
            var old_fn = window[key];
            window[key] = function(){
                $(wrapErrors(function(){
                    var args = arguments;
                    if(olf_fn.length == 0){
                        old_fn();
                        return;
                    }
                    old_fn.apply(null,args);
                }))
            }
        }
    }
}

function captureError(ex){
    var errorData = {
        name: ex.name, // e.g. ReferenceError
        message: ex.message, // e.g. x is undefined
        url: document.location.href,
        stack: ex.stack, // stacktrace string; remember, different per-browser!
        line:ex.lineNumber,
        file:ex.fileName
    }
    $.ajax({
        url:domain + '/error',
        data:errorData,

    })
}

function wrapErrors(fn){
    if(!fn.__wrapped__){
            fn.__wrapped__ = function(){
                try{
                    return fn.apply(this,arguments);
                }
                catch(e){
                    captureError(e);
                    throw e;
                }
            }
        }
        return fn.__wrapped__;
}
