function test_cnn_widget(){
    /// Test function with a custom configuration object ///
    var config = {
        slide_duration:2,
        number_of_slides:5,
        font_color:'black',
        rgba_color:'white',
        font_size:27,
        news:0,
        defaultImage:window.defaultImage,
        feedImage:window.feedImage,
        widget:2
    }

    init_widget(config)
}

/**
 * Convert the 'news' attribute from configuration to the proper URL
 */
function get_CNN_url(){
    window.feedImage = 'assets/cnn.png';
    window.defaultImage = 'assets/cnn-def.png';

    var config = window.options;

    if(!('news' in config)){
        console.log('Invalid configuration file <br> Missing "news" field. ');
        return;
    }

    try{
        config.news = parseInt(config.news);
    }
    catch(err){

    }

    switch(config.news){
        case 0:
            return 'http://rss.cnn.com/rss/edition.rss'; /// Top Stories
        case 1:
            return 'http://rss.cnn.com/rss/edition_world.rss'; // World
        case 2:
            return 'http://rss.cnn.com/rss/edition_africa.rss'; // Africa
        case 3:
            return 'http://rss.cnn.com/rss/edition_americas.rss'; // Americas
        case 4:
            return 'http://rss.cnn.com/rss/edition_asia.rss'; // Asia
        case 5:
            return 'http://rss.cnn.com/rss/edition_europe.rss'; // Europe
        case 6:
            return 'http://rss.cnn.com/rss/edition_meast.rss'; // Middle East
        case 7:
            return 'http://rss.cnn.com/rss/edition_us.rss'; //// U.S.
        case 8:
            return 'http://rss.cnn.com/rss/money_news_international.rss'; /// Money
        case 9:
            return 'http://rss.cnn.com/rss/edition_technology.rss'; /// Technology
        case 10:
            return 'http://rss.cnn.com/rss/edition_space.rss'; //// Science and Space
        case 11:
            return 'http://rss.cnn.com/rss/edition_entertainment.rss'; //// Entertainment
        case 12:
            return 'http://rss.cnn.com/rss/edition_sport.rss'; /// World Sport
        case 13:
            return 'http://rss.cnn.com/rss/edition_football.rss'; /// Football
        case 14:
            return 'http://rss.cnn.com/rss/edition_golf.rss'; /// Golf
        case 15:
            return 'http://rss.cnn.com/rss/edition_motorsport.rss'; //// Motorsport
        case 16:
            return 'http://rss.cnn.com/rss/edition_tennis.rss'; /// Tennis
        case 17:
            return 'http://rss.cnn.com/rss/edition_travel.rss'; //// Travel
        case 18:
            return 'http://rss.cnn.com/rss/cnn_freevideo.rss'; //// Video
        case 19:
            return 'http://rss.cnn.com/rss/cnn_latest.rss'; /// Most Recent
        default:
            return 'http://rss.cnn.com/rss/edition.rss';
    }
}