function test_bbc_widget(){
    /// Test function with a custom configuration object ///
    var config = {
        slide_duration:5,
        number_of_slides:10,
        font_color:'black',
        rgba_color:'white',
        font_size:27,
        news:0,
        defaultImage:window.defaultImage,
        feedImage:window.feedImage,
        widget:1
    }

    init_widget(config)
}

function get_BBC_url(){
    window.feedImage = 'assets/bbc.jpg';
    window.defaultImage = 'assets/bbc-def.png';

    var config = window.options;

    if(!('news' in config)){
        console.log('Invalid configuration file -- Missing "news" field.');
        return;
    }

    try{
        config.news = parseInt(config.news);
    }
    catch(err){

    }

    switch(config.news){
        case 0:
            return 'http://feeds.bbci.co.uk/news/rss.xml'; // Top Stories
        case 1:
            return 'http://feeds.bbci.co.uk/news/world/rss.xml'; // World
        case 2:
            return 'http://feeds.bbci.co.uk/news/uk/rss.xml'; // UK
        case 3:
            return 'http://feeds.bbci.co.uk/news/business/rss.xml'; // Business
        case 4:
            return 'http://feeds.bbci.co.uk/news/politics/rss.xml'; // Politics
        case 5:
            return 'http://feeds.bbci.co.uk/news/health/rss.xml'; // Health
        case 6:
            return 'http://feeds.bbci.co.uk/news/education/rss.xml'; // Family & Education
        case 7:
            return 'http://feeds.bbci.co.uk/news/science_and_environment/rss.xml'; // Science and Enironment
        case 8:
            return 'http://feeds.bbci.co.uk/news/technology/rss.xml'; // Technology
        case 9:
            return 'http://feeds.bbci.co.uk/news/entertainment_and_arts/rss.xml'; // Entertainment & Arts
        default:
            return 'http://feeds.bbci.co.uk/news/rss.xml'; // Defualt "Top Stories"

    }

}
